﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

namespace SendToast
{
    class Program
    {
        static void Main(string[] args)
        {

            string url = "http://db3.notify.live.net/throttledthirdparty/01.00/AAH64HM3bkh" + 
                         "OQJOI4j32ucHqAgAAAAADAQAAAAQUZm52OjIzOEQ2NDJDRkI5MEVFMEQ";

            string data = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" +
                "<wp:Notification xmlns:wp=\"WPNotification\">" +
                   "<wp:Toast>" +
                        "<wp:Text1>Hello</wp:Text1>" +
                        "<wp:Text2>This is a toast notification!</wp:Text2>" +
                        "<wp:Param>/SecondPage.xaml?parameter=Hello World!</wp:Param>" +
                   "</wp:Toast> " +
                "</wp:Notification>";

            WebRequest request = WebRequest.Create(url);

            request.ContentType = "text/xml";
            request.Method = "POST";
            request.Headers.Add("X-WindowsPhone-Target", "toast");
            request.Headers.Add("X-NotificationClass", "2");

            byte[] bytes = Encoding.UTF8.GetBytes(data);

            using (Stream requestStream = request.GetRequestStream())
            {
                requestStream.Write(bytes, 0, bytes.Length);
                try
                {
                    HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                    string notificationStatus = response.Headers["X-NotificationStatus"];
                    string subscriptionStatus = response.Headers["X-SubscriptionStatus"];
                    string connectionStatus = response.Headers["X-DeviceConnectionStatus"];

                    Console.Write(String.Format("X-NotificationStatus:{0}\r\nX-Subscription" +
                                                "Status:{1}\r\nX-DeviceConnectionStatus:{2}",
                        notificationStatus, subscriptionStatus, connectionStatus));
                    Console.ReadKey();
                }
                catch (WebException ex)
                {
                    Console.Write("WebExeption occured with Statuscode:" +
                        ((HttpWebResponse)ex.Response).StatusCode.ToString());
                    Console.ReadKey();
                }
            }

        }
    }
}
